<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Caderno de Erros - Notas de Estudo</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <header>
            <h1>📚 Caderno de Erros</h1>
            <p class="subtitle">Notas de Estudo e Revisão</p>
        </header>

        <main>
            <?php
            // Diretórios
            $notasDir = __DIR__ . '/notas';
            $imgDir = __DIR__ . '/img';
            
            // Obtém parâmetros via GET
            $selectedFile = isset($_GET['file']) ? $_GET['file'] : null;
            $selectedImage = isset($_GET['img']) ? $_GET['img'] : null;
            $tab = isset($_GET['tab']) ? $_GET['tab'] : 'notas';
            
            // Valida o arquivo selecionado para evitar problemas de segurança
            if ($selectedFile) {
                $selectedFile = basename($selectedFile); // Remove path traversal
                $filePath = $notasDir . '/' . $selectedFile;
                
                // Verifica se o arquivo existe e tem extensão .md
                if (file_exists($filePath) && pathinfo($filePath, PATHINFO_EXTENSION) === 'md') {
                    // Exibe o conteúdo do arquivo
                    echo '<div class="breadcrumb">';
                    echo '<a href="index.php">← Voltar para lista</a>';
                    echo '</div>';
                    
                    echo '<article class="nota-content">';
                    echo '<h2>' . htmlspecialchars(pathinfo($selectedFile, PATHINFO_FILENAME)) . '</h2>';
                    
                    $content = file_get_contents($filePath);
                    
                    // Converte markdown básico para HTML
                    $content = convertMarkdownToHtml($content);
                    
                    echo '<div class="text-content">' . $content . '</div>';
                    echo '</article>';
                } else {
                    echo '<div class="error">Arquivo não encontrado.</div>';
                }
            } elseif ($selectedImage) {
                // Visualização de imagem individual
                $selectedImage = basename($selectedImage);
                $imagePath = $imgDir . '/' . $selectedImage;
                
                // Extensões de imagem permitidas
                $allowedExts = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'svg', 'bmp'];
                $ext = strtolower(pathinfo($imagePath, PATHINFO_EXTENSION));
                
                if (file_exists($imagePath) && in_array($ext, $allowedExts)) {
                    echo '<div class="breadcrumb">';
                    echo '<a href="index.php?tab=imagens">← Voltar para galeria</a>';
                    echo '</div>';
                    
                    echo '<article class="image-viewer">';
                    echo '<h2>' . htmlspecialchars(pathinfo($selectedImage, PATHINFO_FILENAME)) . '</h2>';
                    
                    echo '<div class="image-container">';
                    echo '<img src="img/' . htmlspecialchars($selectedImage) . '" alt="' . htmlspecialchars($selectedImage) . '">';
                    echo '</div>';
                    
                    echo '<div class="image-actions">';
                    echo '<a href="img/' . htmlspecialchars($selectedImage) . '" download class="btn-download">⬇️ Baixar Imagem</a>';
                    $fileSize = filesize($imagePath);
                    $fileSizeKB = round($fileSize / 1024, 2);
                    echo '<span class="image-info">' . strtoupper($ext) . ' • ' . $fileSizeKB . ' KB</span>';
                    echo '</div>';
                    
                    echo '</article>';
                } else {
                    echo '<div class="error">Imagem não encontrada.</div>';
                }
            } else {
                // Tabs de navegação
                echo '<div class="tabs">';
                echo '<a href="?tab=notas" class="tab-link ' . ($tab === 'notas' ? 'active' : '') . '">📝 Notas</a>';
                echo '<a href="?tab=imagens" class="tab-link ' . ($tab === 'imagens' ? 'active' : '') . '">🖼️ Imagens</a>';
                echo '</div>';
                
                if ($tab === 'imagens') {
                    // Galeria de imagens
                    echo '<div class="search-box">';
                    echo '<input type="text" id="searchInput" placeholder="🔍 Buscar imagens..." onkeyup="filterItems()">';
                    echo '</div>';
                    
                    echo '<div class="images-grid" id="itemsGrid">';
                    
                    if (is_dir($imgDir)) {
                        $files = scandir($imgDir);
                        $allowedExts = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'svg', 'bmp'];
                        $imageFiles = array_filter($files, function($file) use ($allowedExts) {
                            $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
                            return in_array($ext, $allowedExts);
                        });
                        
                        if (count($imageFiles) > 0) {
                            foreach ($imageFiles as $file) {
                                $fileName = pathinfo($file, PATHINFO_FILENAME);
                                $fileSize = filesize($imgDir . '/' . $file);
                                $fileSizeKB = round($fileSize / 1024, 2);
                                
                                echo '<div class="image-card">';
                                echo '<a href="?img=' . urlencode($file) . '" class="image-link">';
                                echo '<div class="image-thumb">';
                                echo '<img src="img/' . htmlspecialchars($file) . '" alt="' . htmlspecialchars($fileName) . '">';
                                echo '</div>';
                                echo '<h3>' . htmlspecialchars($fileName) . '</h3>';
                                echo '</a>';
                                echo '<div class="image-card-actions">';
                                echo '<span class="nota-meta">' . $fileSizeKB . ' KB</span>';
                                echo '<a href="img/' . htmlspecialchars($file) . '" download class="btn-download-small" title="Baixar">⬇️</a>';
                                echo '</div>';
                                echo '</div>';
                            }
                        } else {
                            echo '<div class="no-files">Nenhuma imagem encontrada. Adicione imagens na pasta <code>img/</code></div>';
                        }
                    } else {
                        echo '<div class="error">Diretório de imagens não encontrado.</div>';
                    }
                    
                    echo '</div>';
                } else {
                    // Lista de notas (código original)
                    echo '<div class="search-box">';
                    echo '<input type="text" id="searchInput" placeholder="🔍 Buscar notas..." onkeyup="filterItems()">';
                    echo '</div>';
                    
                    echo '<div class="notas-grid" id="itemsGrid">';
                    
                    if (is_dir($notasDir)) {
                        $files = scandir($notasDir);
                        $mdFiles = array_filter($files, function($file) {
                            return pathinfo($file, PATHINFO_EXTENSION) === 'md';
                        });
                        
                        if (count($mdFiles) > 0) {
                            foreach ($mdFiles as $file) {
                                $fileName = pathinfo($file, PATHINFO_FILENAME);
                                $fileSize = filesize($notasDir . '/' . $file);
                                $fileSizeKB = round($fileSize / 1024, 2);
                                
                                echo '<a href="?file=' . urlencode($file) . '" class="nota-card">';
                                echo '<div class="nota-icon">📝</div>';
                                echo '<h3>' . htmlspecialchars($fileName) . '</h3>';
                                echo '<div class="nota-meta">' . $fileSizeKB . ' KB</div>';
                                echo '</a>';
                            }
                        } else {
                            echo '<div class="no-files">Nenhuma nota encontrada.</div>';
                        }
                    } else {
                        echo '<div class="error">Diretório de notas não encontrado.</div>';
                    }
                    
                    echo '</div>';
                }
            }
            
            // Função para converter markdown básico em HTML
            function convertMarkdownToHtml($text) {
                // Escapa HTML
                $text = htmlspecialchars($text);
                
                // Converte quebras de linha
                $text = nl2br($text);
                
                // Headers (### ## #)
                $text = preg_replace('/^### (.+)$/m', '<h3>$1</h3>', $text);
                $text = preg_replace('/^## (.+)$/m', '<h2>$1</h2>', $text);
                $text = preg_replace('/^# (.+)$/m', '<h1>$1</h1>', $text);
                
                // Bold **texto**
                $text = preg_replace('/\*\*(.+?)\*\*/s', '<strong>$1</strong>', $text);
                
                // Italic *texto*
                $text = preg_replace('/\*(.+?)\*/s', '<em>$1</em>', $text);
                
                // Links [texto](url)
                $text = preg_replace('/\[(.+?)\]\((.+?)\)/', '<a href="$2" target="_blank">$1</a>', $text);
                
                // Listas não ordenadas
                $text = preg_replace('/^- (.+)$/m', '<li>$1</li>', $text);
                $text = preg_replace('/(<li>.*<\/li>)/s', '<ul>$1</ul>', $text);
                
                return $text;
            }
            ?>
        </main>

        <footer>
            <p>Última atualização: <?php echo date('d/m/Y H:i'); ?></p>
        </footer>
    </div>

    <script>
        function filterItems() {
            const input = document.getElementById('searchInput');
            const filter = input.value.toLowerCase();
            const grid = document.getElementById('itemsGrid');
            
            // Verifica se é grid de notas ou imagens
            const isNotasGrid = grid.classList.contains('notas-grid');
            const cards = isNotasGrid ? 
                grid.getElementsByClassName('nota-card') : 
                grid.getElementsByClassName('image-card');

            for (let i = 0; i < cards.length; i++) {
                const title = cards[i].getElementsByTagName('h3')[0];
                const txtValue = title.textContent || title.innerText;
                
                if (txtValue.toLowerCase().indexOf(filter) > -1) {
                    cards[i].style.display = '';
                } else {
                    cards[i].style.display = 'none';
                }
            }
        }
    </script>
</body>
</html>
